<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$pdo = db();
$requiredPerLevel = [1 => 5, 2 => 25, 3 => 125, 4 => 625, 5 => 3125, 6 => 15625];

// Registration counts by date
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'user' AND DATE(created_at) = CURDATE()");
$todayRegistered = (int) $stmt->fetchColumn();
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'user' AND YEAR(created_at) = YEAR(CURDATE()) AND MONTH(created_at) = MONTH(CURDATE())");
$monthRegistered = (int) $stmt->fetchColumn();
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'user' AND YEAR(created_at) = YEAR(CURDATE())");
$yearRegistered = (int) $stmt->fetchColumn();

// KYC counts
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'user' AND kyc_status = 'pending'");
$kycPending = (int) $stmt->fetchColumn();
$stmt = $pdo->query("SELECT COUNT(*) FROM users WHERE role = 'user' AND kyc_status = 'approved'");
$kycCompleted = (int) $stmt->fetchColumn();

// Level completed counts: for each approved user, compute level counts and check completion
$levelCompleted = [1 => 0, 2 => 0, 3 => 0, 4 => 0, 5 => 0, 6 => 0];
$stmt = $pdo->query("SELECT id FROM users WHERE role = 'user' AND status = 'approved'");
$userIds = [];
while ($r = $stmt->fetch()) {
    $userIds[] = (string) $r['id'];
}
foreach ($userIds as $userId) {
    $levelCounts = [1 => 0, 2 => 0, 3 => 0, 4 => 0, 5 => 0, 6 => 0];
    $stack = [[$userId, 1]];
    while (!empty($stack)) {
        [$pid, $depth] = array_shift($stack);
        if ($depth > 6) continue;
        $st = $pdo->prepare('SELECT id FROM users WHERE referred_by = ? AND status = ?');
        $st->execute([$pid, 'approved']);
        while ($u = $st->fetch()) {
            $levelCounts[$depth]++;
            $stack[] = [(string) $u['id'], $depth + 1];
        }
    }
    for ($l = 1; $l <= 6; $l++) {
        if ($levelCounts[$l] >= $requiredPerLevel[$l]) {
            $levelCompleted[$l]++;
        }
    }
}

// Withdrawals: today's requests (count + amount)
$stmt = $pdo->query("SELECT COUNT(*), COALESCE(SUM(ABS(amount)), 0) FROM wallet_transactions WHERE type = 'withdrawal' AND DATE(created_at) = CURDATE()");
$row = $stmt->fetch();
$withdrawalsTodayCount = (int) $row[0];
$withdrawalsTodayAmount = (float) $row[1];

// Approved today: use processed_at if column exists
$approvedTodayCount = 0;
$approvedTodayAmount = 0.0;
try {
    $stmt = $pdo->query("SELECT COUNT(*), COALESCE(SUM(ABS(amount)), 0) FROM wallet_transactions WHERE type = 'withdrawal' AND status = 'completed' AND DATE(processed_at) = CURDATE()");
    if ($stmt) {
        $row = $stmt->fetch();
        $approvedTodayCount = (int) $row[0];
        $approvedTodayAmount = (float) $row[1];
    }
} catch (Throwable $e) {
    // processed_at column may not exist yet
}

jsonResponse([
    'success' => true,
    'todayRegistered' => $todayRegistered,
    'monthRegistered' => $monthRegistered,
    'yearRegistered' => $yearRegistered,
    'level1Completed' => $levelCompleted[1],
    'level2Completed' => $levelCompleted[2],
    'level3Completed' => $levelCompleted[3],
    'level4Completed' => $levelCompleted[4],
    'level5Completed' => $levelCompleted[5],
    'level6Completed' => $levelCompleted[6],
    'kycPending' => $kycPending,
    'kycCompleted' => $kycCompleted,
    'withdrawalsTodayCount' => $withdrawalsTodayCount,
    'withdrawalsTodayAmount' => $withdrawalsTodayAmount,
    'approvedTodayCount' => $approvedTodayCount,
    'approvedTodayAmount' => $approvedTodayAmount,
]);