<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$input = getJsonInput();
$transactionId = $input['transactionId'] ?? '';
$action = $input['action'] ?? 'approved';
if (!$transactionId) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'transactionId required']);
    return;
}

$stmt = db()->prepare('SELECT * FROM wallet_transactions WHERE id = ? AND type = ? AND status = ?');
$stmt->execute([$transactionId, 'withdrawal', 'pending']);
$t = $stmt->fetch();
if (!$t) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'Withdrawal not found or already processed']);
    return;
}

$newStatus = $action === 'approved' ? 'completed' : 'rejected';
$pdo = db();
$pdo->prepare('UPDATE wallet_transactions SET status = ?, processed_at = NOW() WHERE id = ?')->execute([$newStatus, $transactionId]);

if ($action === 'rejected') {
    $userId = $t['user_id'];
    $amount = abs((float) $t['amount']);
    $stmt = db()->prepare('SELECT wallet_balance FROM users WHERE id = ?');
    $stmt->execute([$userId]);
    $u = $stmt->fetch();
    $newBal = (float) $u['wallet_balance'] + $amount;
    db()->prepare('UPDATE users SET wallet_balance = ? WHERE id = ?')->execute([$newBal, $userId]);
}
jsonResponse(['success' => true]);
