<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$userId = $_GET['userId'] ?? '';
if (!$userId) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'userId required']);
    return;
}

$pdo = db();
$stmt = $pdo->prepare('SELECT * FROM users WHERE id = ? AND role = ?');
$stmt->execute([$userId, 'user']);
$row = $stmt->fetch();
if (!$row) {
    http_response_code(404);
    jsonResponse(['success' => false, 'message' => 'User not found']);
    return;
}

$user = rowToUser($row);
unset($user['password']);

$levelCounts = [1 => 0, 2 => 0, 3 => 0, 4 => 0, 5 => 0, 6 => 0];
$stack = [[$userId, 1]];
while (!empty($stack)) {
    [$pid, $depth] = array_shift($stack);
    if ($depth > 6) continue;
    $stmt = $pdo->prepare('SELECT id FROM users WHERE referred_by = ? AND status = ?');
    $stmt->execute([$pid, 'approved']);
    while ($u = $stmt->fetch()) {
        $levelCounts[$depth]++;
        $stack[] = [(string) $u['id'], $depth + 1];
    }
}

$requiredPerLevel = [1 => 5, 2 => 25, 3 => 125, 4 => 625, 5 => 3125, 6 => 15625];
$levelComplete = [];
for ($l = 1; $l <= 6; $l++) {
    $levelComplete[$l] = $levelCounts[$l] >= $requiredPerLevel[$l];
}

function buildChildren(PDO $pdo, string $parentId, int $level): array {
    if ($level > 6) return [];
    $stmt = $pdo->prepare('SELECT id, referral_id, name, number, email FROM users WHERE referred_by = ? AND status = ?');
    $stmt->execute([$parentId, 'approved']);
    $list = [];
    while ($u = $stmt->fetch()) {
        $id = (string) $u['id'];
        $list[] = [
            'id' => $id,
            'referralId' => $u['referral_id'] ?? '',
            'name' => $u['name'] ?? '',
            'number' => $u['number'] ?? '',
            'email' => $u['email'] ?? '',
            'level' => $level,
            'children' => buildChildren($pdo, $id, $level + 1),
        ];
    }
    return $list;
}

$hierarchy = buildChildren($pdo, $userId, 1);

$kycDetails = null;
if (!empty($row['kyc_aadhar_number'])) {
    $kycDetails = [
        'aadharNumber' => $row['kyc_aadhar_number'] ?? '',
        'panNumber' => $row['kyc_pan_number'] ?? '',
        'bankName' => $row['kyc_bank_name'] ?? '',
        'bankAccountNumber' => $row['kyc_bank_account_number'] ?? '',
        'bankIfsc' => $row['kyc_bank_ifsc'] ?? '',
        'accountHolderName' => $row['kyc_account_holder_name'] ?? '',
        'kycStatus' => $row['kyc_status'] ?? 'pending',
        'aadharImage' => $row['kyc_aadhar_image'] ?? null,
        'panImage' => $row['kyc_pan_image'] ?? null,
    ];
}

jsonResponse([
    'success' => true,
    'user' => $user,
    'levelCounts' => $levelCounts,
    'requiredPerLevel' => $requiredPerLevel,
    'levelComplete' => $levelComplete,
    'hierarchy' => $hierarchy,
    'kycDetails' => $kycDetails,
]);
