<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$dateFilter = $_GET['dateFilter'] ?? ''; // today, month, year
$fromDate = $_GET['fromDate'] ?? null;
$toDate = $_GET['toDate'] ?? null;

$where = ['role = ?'];
$params = ['user'];
if ($dateFilter === 'today') {
    $where[] = 'DATE(created_at) = CURDATE()';
} elseif ($dateFilter === 'month') {
    $where[] = 'YEAR(created_at) = YEAR(CURDATE()) AND MONTH(created_at) = MONTH(CURDATE())';
} elseif ($dateFilter === 'year') {
    $where[] = 'YEAR(created_at) = YEAR(CURDATE())';
} elseif ($fromDate && preg_match('/^\d{4}-\d{2}-\d{2}$/', $fromDate)) {
    $where[] = 'DATE(created_at) >= ?';
    $params[] = $fromDate;
}
if ($toDate && preg_match('/^\d{4}-\d{2}-\d{2}$/', $toDate)) {
    $where[] = 'DATE(created_at) <= ?';
    $params[] = $toDate;
}

$sql = 'SELECT * FROM users WHERE ' . implode(' AND ', $where) . ' ORDER BY created_at DESC';
$stmt = db()->prepare($sql);
$stmt->execute($params);
$list = [];
while ($u = $stmt->fetch()) {
    $list[] = [
        'id' => (string) $u['id'],
        'name' => $u['name'] ?? '',
        'email' => $u['email'] ?? '',
        'number' => $u['number'] ?? '',
        'referralId' => $u['referral_id'] ?? '',
        'status' => $u['status'] ?? '',
        'walletBalance' => (float) ($u['wallet_balance'] ?? 0),
        'kycStatus' => $u['kyc_status'] ?? 'pending',
        'createdAt' => $u['created_at'] ? (new DateTime($u['created_at']))->format('c') : null,
        'registrationSubmittedAt' => $u['registration_submitted_at'] ? (new DateTime($u['registration_submitted_at']))->format('c') : null,
        'approvedAt' => $u['approved_at'] ? (new DateTime($u['approved_at']))->format('c') : null,
    ];
}
jsonResponse(['success' => true, 'users' => $list]);
