<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$statusFilter = $_GET['status'] ?? null;
$fromDate = $_GET['fromDate'] ?? null; // Y-m-d
$toDate = $_GET['toDate'] ?? null;     // Y-m-d

$where = ['type = ?'];
$params = ['withdrawal'];
if ($statusFilter) {
    $where[] = 'status = ?';
    $params[] = $statusFilter;
}
if ($fromDate && preg_match('/^\d{4}-\d{2}-\d{2}$/', $fromDate)) {
    $where[] = 'DATE(created_at) >= ?';
    $params[] = $fromDate;
}
if ($toDate && preg_match('/^\d{4}-\d{2}-\d{2}$/', $toDate)) {
    $where[] = 'DATE(created_at) <= ?';
    $params[] = $toDate;
}

$sql = 'SELECT * FROM wallet_transactions WHERE ' . implode(' AND ', $where) . ' ORDER BY created_at DESC';
$stmt = db()->prepare($sql);
$stmt->execute($params);
$list = [];
while ($t = $stmt->fetch()) {
    $stmtU = db()->prepare('SELECT name, email, number, kyc_bank_account_number, kyc_bank_ifsc, kyc_account_holder_name, kyc_bank_name FROM users WHERE id = ?');
    $stmtU->execute([$t['user_id']]);
    $u = $stmtU->fetch();
    $list[] = [
        'id' => (string) $t['id'],
        'userId' => (string) $t['user_id'],
        'userName' => $u['name'] ?? '',
        'userEmail' => $u['email'] ?? '',
        'userNumber' => $u['number'] ?? '',
        'amount' => abs((float) $t['amount']),
        'bankAccount' => $u['kyc_bank_account_number'] ?? '',
        'bankIfsc' => $u['kyc_bank_ifsc'] ?? '',
        'bankName' => $u['kyc_bank_name'] ?? '',
        'accountHolderName' => $u['kyc_account_holder_name'] ?? '',
        'status' => $t['status'] ?? 'pending',
        'createdAt' => $t['created_at'] ? (new DateTime($t['created_at']))->format('c') : null,
    ];
}
jsonResponse(['success' => true, 'withdrawals' => $list]);
