<?php
require __DIR__ . '/../../../bootstrap.php';

$input = getJsonInput();
$email = trim($input['email'] ?? '');
$password = $input['password'] ?? '';

if (!$email || !$password) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'Email and password required']);
    return;
}

$stmt = db()->prepare('SELECT * FROM users WHERE email = ?');
$stmt->execute([$email]);
$row = $stmt->fetch();
if (!$row || !password_verify($password, $row['password'] ?? '')) {
    http_response_code(401);
    jsonResponse(['success' => false, 'message' => 'Invalid credentials']);
    return;
}

$role = $row['role'] ?? 'user';
$status = $row['status'] ?? 'pending';

// Only approved users can login. Admins are always allowed.
if ($role !== 'admin' && $status !== 'approved') {
    http_response_code(403);
    if ($status === 'pending') {
        jsonResponse(['success' => false, 'message' => 'Your registration is still pending. Please wait until we approve your registration.']);
    } else {
        jsonResponse(['success' => false, 'message' => 'Your registration has been rejected.']);
    }
    return;
}

$user = rowToUser($row);
unset($user['password']);

$payload = ['uid' => $user['id'], 'email' => $user['email'], 'exp' => time() + 86400 * 7];
$token = \Firebase\JWT\JWT::encode($payload, $_ENV['JWT_SECRET'] ?? 'secret', 'HS256');
jsonResponse(['success' => true, 'token' => $token, 'user' => $user]);
