<?php
require __DIR__ . '/../../../bootstrap.php';

$input = getJsonInput();
$number = trim($input['number'] ?? '');
$name = trim($input['name'] ?? '');
$email = trim($input['email'] ?? '');
$password = $input['password'] ?? '';
$dateOfBirth = trim($input['dateOfBirth'] ?? '');
$referralCode = trim($input['referralCode'] ?? '');

if (!$number || !$name || !$email || !$password || !$dateOfBirth || !$referralCode) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'All fields are required: number, name, email, password, dateOfBirth, referralCode']);
    return;
}

$pdo = db();
$stmt = $pdo->prepare('SELECT id FROM users WHERE email = ?');
$stmt->execute([$email]);
if ($stmt->fetch()) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'Email already registered']);
    return;
}
$stmt = $pdo->prepare('SELECT id FROM users WHERE number = ?');
$stmt->execute([$number]);
if ($stmt->fetch()) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'Number already registered']);
    return;
}

$stmt = $pdo->prepare('SELECT id FROM users WHERE referral_id = ? AND status = ?');
$stmt->execute([$referralCode, 'approved']);
$referrer = $stmt->fetch();
if (!$referrer) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'Invalid referral code']);
    return;
}

$referralId = generateReferralId();
$referredBy = (int) $referrer['id'];
$dob = $dateOfBirth !== '' ? $dateOfBirth : null;

$stmt = $pdo->prepare('INSERT INTO users (number, name, email, password, date_of_birth, referral_id, referred_by, status, role, wallet_balance, min_withdraw_balance, kyc_status) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)');
$stmt->execute([
    $number,
    $name,
    $email,
    password_hash($password, PASSWORD_DEFAULT),
    $dob,
    $referralId,
    $referredBy,
    'pending',
    'user',
    0,
    0,
    'pending',
]);
$id = (string) $pdo->lastInsertId();

$payload = ['uid' => $id, 'email' => $email, 'exp' => time() + 86400 * 7];
$token = \Firebase\JWT\JWT::encode($payload, $_ENV['JWT_SECRET'] ?? 'secret', 'HS256');
$user = ['id' => $id, '_id' => $id, 'number' => $number, 'name' => $name, 'email' => $email, 'referralId' => $referralId, 'status' => 'pending'];
jsonResponse(['success' => true, 'token' => $token, 'user' => $user]);
