<?php
require __DIR__ . '/../../../bootstrap.php';

$user = requireAuth();
$input = getJsonInput();
$aadharNumber = trim($input['aadharNumber'] ?? '');
$aadharImage = $input['aadharImage'] ?? '';
$panNumber = trim($input['panNumber'] ?? '');
$panImage = $input['panImage'] ?? '';
$bankAccountNumber = trim($input['bankAccountNumber'] ?? '');
$bankIfsc = trim($input['bankIfsc'] ?? '');
$bankName = trim($input['bankName'] ?? '');
$accountHolderName = trim($input['accountHolderName'] ?? '');

if (!$aadharNumber || !$aadharImage || !$panNumber || !$panImage || !$bankAccountNumber || !$bankIfsc || !$bankName || !$accountHolderName) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'All KYC fields required']);
    return;
}

$stmt = db()->prepare('UPDATE users SET kyc_aadhar_number = ?, kyc_aadhar_image = ?, kyc_pan_number = ?, kyc_pan_image = ?, kyc_bank_account_number = ?, kyc_bank_ifsc = ?, kyc_bank_name = ?, kyc_account_holder_name = ?, kyc_status = ?, kyc_submitted_at = NOW() WHERE id = ?');
$stmt->execute([
    $aadharNumber, $aadharImage, $panNumber, $panImage,
    $bankAccountNumber, $bankIfsc, $bankName, $accountHolderName,
    'pending', $user['_id'],
]);
jsonResponse(['success' => true, 'message' => 'KYC submitted for approval']);
