<?php
require __DIR__ . '/../../../bootstrap.php';

$user = requireAuth();
$userId = $user['_id'];
$pdo = db();

$levelCounts = [1 => 0, 2 => 0, 3 => 0, 4 => 0, 5 => 0, 6 => 0];
$stack = [[$userId, 1]];
while (!empty($stack)) {
    [$pid, $depth] = array_shift($stack);
    if ($depth > 6) continue;
    $stmt = $pdo->prepare('SELECT id FROM users WHERE referred_by = ? AND status = ?');
    $stmt->execute([$pid, 'approved']);
    while ($u = $stmt->fetch()) {
        $levelCounts[$depth]++;
        $stack[] = [(string) $u['id'], $depth + 1];
    }
}

$requiredPerLevel = [1 => 5, 2 => 25, 3 => 125, 4 => 625, 5 => 3125, 6 => 15625];
$levelComplete = [];
for ($l = 1; $l <= 6; $l++) {
    $levelComplete[$l] = $levelCounts[$l] >= $requiredPerLevel[$l];
}

jsonResponse([
    'success' => true,
    'levelCounts' => $levelCounts,
    'requiredPerLevel' => $requiredPerLevel,
    'levelComplete' => $levelComplete,
    'totalReferrals' => array_sum($levelCounts),
    'commissionPerLevel' => COMMISSION_AMOUNTS,
]);
