<?php
require __DIR__ . '/../../../bootstrap.php';

$user = requireAuth();

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    unset($user['password']);
    jsonResponse(['success' => true, 'user' => $user]);
    return;
}

$input = getJsonInput();
$updates = [];
$params = [];
if (isset($input['name'])) { $updates[] = 'name = ?'; $params[] = trim((string) $input['name']); }
if (isset($input['number'])) { $updates[] = 'number = ?'; $params[] = trim((string) $input['number']); }
if (isset($input['dateOfBirth'])) { $updates[] = 'date_of_birth = ?'; $params[] = trim((string) $input['dateOfBirth']); }
if (!empty($updates)) {
    $params[] = $user['_id'];
    $sql = 'UPDATE users SET ' . implode(', ', $updates) . ' WHERE id = ?';
    db()->prepare($sql)->execute($params);
}
$stmt = db()->prepare('SELECT * FROM users WHERE id = ?');
$stmt->execute([$user['_id']]);
$row = $stmt->fetch();
$user = rowToUser($row);
unset($user['password']);
jsonResponse(['success' => true, 'user' => $user]);
