<?php
declare(strict_types=1);

// CORS
$origin = $_ENV['CORS_ORIGIN'] ?? '*';
header("Access-Control-Allow-Origin: $origin");
header("Access-Control-Allow-Methods: GET, POST, PUT, DELETE, OPTIONS");
header("Access-Control-Allow-Headers: Content-Type, Authorization");
header("Content-Type: application/json; charset=UTF-8");
if ($_SERVER['REQUEST_METHOD'] === 'OPTIONS') {
    http_response_code(204);
    exit;
}

require __DIR__ . '/../vendor/autoload.php';

$dotenv = Dotenv\Dotenv::class;
if (class_exists($dotenv)) {
    (new $dotenv(__DIR__ . '/..'))->load();
}

$uri = parse_url($_SERVER['REQUEST_URI'], PHP_URL_PATH);
$requestMethod = $_SERVER['REQUEST_METHOD'];

$routes = require __DIR__ . '/../config/routes.php';
if (isset($routes[$requestMethod][$uri])) {
    $handler = $routes[$requestMethod][$uri];
    $handler();
} else {
    http_response_code(404);
    echo json_encode(['success' => false, 'message' => 'Not found']);
}
