<?php
/**
 * One-time script: add approved_at column to users table if missing.
 * Run from CLI: php scripts/add-approved-at-column.php
 * Or open in browser: http://localhost/bonza/backend/scripts/add-approved-at-column.php
 */
require __DIR__ . '/../bootstrap.php';

$pdo = db();
try {
    $pdo->exec('ALTER TABLE `users` ADD COLUMN `approved_at` DATETIME NULL AFTER `registration_submitted_at`');
    echo "Column approved_at added successfully.\n";
} catch (PDOException $e) {
    if (strpos($e->getMessage(), 'Duplicate column') !== false) {
        echo "Column approved_at already exists.\n";
    } else {
        echo "Error: " . $e->getMessage() . "\n";
        exit(1);
    }
}
